package org.msh.tb.bd.tbforms.dhis2.tb12.blockbuilders;

import org.msh.tb.bd.entities.enums.SmearStatus;
import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb12.TB12Column;
import org.msh.tb.bd.tbforms.query.tb12.TB12Row;
import org.msh.tb.bd.tbforms.query.tb12.TBForm12Table2Query;
import org.msh.tb.entities.enums.CaseState;
import org.msh.tb.entities.enums.Gender;
import org.msh.tb.entities.enums.PatientType;

/**
 * Created by Mauricio Santos on 20/04/2017.
 */
public class TBForm12Table2Builder extends TBFormBlockBuilder{

    private TbFormQuery tbFormQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for (TB12Column c : TB12Column.values()) {
            // no need to send grand total or total registered
            if (!(c.equals(TB12Column.GRAND_TOTAL) || c.equals(TB12Column.TOTAL_REGISTERED))) {

                for (TB12Row r : TB12Row.values()) {
                    // no need to send total
                    if (!r.equals(TB12Row.TOTAL)) {
                        payload.mergeDataValue(r.getTable2DataElementId(), c.getMaleCocDHIS2Id(), new Long(0));
                        payload.mergeDataValue(r.getTable2DataElementId(), c.getFemaleCocDHIS2Id(), new Long(0));
                    }
                }

            }
        }
    }

    @Override
    protected TbFormQuery getBlockQuery() {
        if (tbFormQuery == null) {
            tbFormQuery = new TBForm12Table2Query();
        }

        return tbFormQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        int queryType = (Integer) result[0];

        switch(queryType) {
            case 0:
                mergeSmearValue(result, payload);
                break;
            case 1:
                mergeOutcomeValue(result, payload);
                break;
        }
    }

    private void mergeSmearValue(Object[] o, DataValuePayload payload) {
        PatientType pt = (PatientType) o[1];
        PatientType prevPt = (PatientType) o[2];
        Gender g = (Gender) o[3];
        SmearStatus smear = (SmearStatus) o[4];
        Long qtd = (Long) o[5];

        if (smear.equals(SmearStatus.SMEAR_POSITIVE)) {
            // DHIS2 TB 12 table 2 doesn't count Smear Positive column
            return;
        }

        payload.mergeDataValue(TB12Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt).getTable2DataElementId(),
                TB12Column.getDHIS2CocId(smear, g),
                qtd);
    }

    private void mergeOutcomeValue(Object[] o, DataValuePayload payload) {
        PatientType pt = (PatientType) o[1];
        PatientType prevPt = (PatientType) o[2];
        Gender g = (Gender) o[3];
        CaseState caseState = (CaseState) o[4];
        Long qtd = (Long) o[5];

        payload.mergeDataValue(TB12Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt).getTable2DataElementId(),
                TB12Column.getDHIS2CocId(caseState, g),
                qtd);
    }
}
